
document.addEventListener('DOMContentLoaded', function() {
    if (document.getElementById('diseaseChart')) {
        initCharts();
    }
});

function initCharts() {

    const diseaseCtx = document.getElementById('diseaseChart').getContext('2d');
    const diseaseChart = new Chart(diseaseCtx, {
        type: 'line',
        data: {
            labels: ['Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн', 'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек'],
            datasets: [{
                label: 'ОРВИ',
                data: [1200, 1100, 900, 700, 500, 300, 250, 280, 400, 600, 800, 1100],
                borderColor: '#0d6efd',
                backgroundColor: 'rgba(13, 110, 253, 0.1)',
                tension: 0.4
            }, {
                label: 'Пневмония',
                data: [45, 40, 35, 30, 25, 20, 18, 20, 25, 30, 35, 40],
                borderColor: '#dc3545',
                backgroundColor: 'rgba(220, 53, 69, 0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            }
        }
    });

    const ageCtx = document.getElementById('ageChart').getContext('2d');
    const ageChart = new Chart(ageCtx, {
        type: 'doughnut',
        data: {
            labels: ['0-14 лет', '15-30 лет', '31-50 лет', '51-70 лет', '70+ лет'],
            datasets: [{
                data: [25, 15, 20, 25, 15],
                backgroundColor: [
                    '#0d6efd',
                    '#198754',
                    '#ffc107',
                    '#dc3545',
                    '#6f42c1'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    window.charts = {
        disease: diseaseChart,
        age: ageChart
    };
}

function updateChartsData(year, dataType, district) {


    
    console.log('Обновление графиков с параметрами:', { year, dataType, district });

    if (window.charts && window.charts.disease) {
        const newData = Array.from({length: 12}, () => Math.floor(Math.random() * 1000) + 500);
        window.charts.disease.data.datasets[0].data = newData;
        window.charts.disease.update();
    }
}

window.MIACCharts = {
    initCharts: initCharts,
    updateChartsData: updateChartsData
};